function cds = set_ai(cds, ai, dates)
% --------------------------------------------------------------------------------------------------
% Set the exposures of the individual firms to the systematic factor
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% ai        ... vector of exposures to systematic factor
% dates     ... matching vector of dates
% --------------------------------------------------------------------------------------------------
% sample call: set_ai(cdx_mor.portfolio(1), 0.5, cdx_mor.portfolio(1).dates{1});
% --------------------------------------------------------------------------------------------------

% Determine matching dates
[trash, used_pos_cds, used_pos_params] = intersect_sorted(cds.dates{1}, dates);
cds.ai(used_pos_cds,:) = ai(used_pos_params,:);